% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory_flextable.R
\name{factory_flextable}
\alias{factory_flextable}
\title{Internal function to build table with `flextable`}
\usage{
factory_flextable(tab, title, stars, stars_note, notes, gof_idx, output, ...)
}
\arguments{
\item{title}{string}

\item{stars}{to indicate statistical significance
\itemize{
  \item FALSE (default): no significance stars. 
  \item TRUE: *=.1, **=.05, ***=.01
  \item Named numeric vector for custom stars such as `c('*' = .1, '+' = .05)`
}}

\item{stars_note}{passed by `modelsummary()`}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{output}{filename or object type (string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg. 
  \item Supported object types: "default", "html", "markdown", "latex", "gt", "kableExtra", "huxtable", "flextable".
  \item When a file name is supplied to the `output` argument, the table is written immediately to file. If you want to customize your table by post-processing it with functions provided by the `gt` or `kableExtra` packages, you need to choose a different output format (e.g., "gt", "latex", "html", "markdown"), and you need to save the table after post-processing using the `gt::gtsave`, `kable::save_kable`, or `cat` functions.
}}

\item{...}{all other arguments are passed to the `tidy` method used to
extract estimates from the model. For example, this allows users to set
`exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\value{
flextable object
}
\description{
Internal function to build table with `flextable`
}
\keyword{internal}
