% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory.R
\name{factory}
\alias{factory}
\title{Factory to create tables in different output formats using standardized
inputs.}
\usage{
factory(
  tab,
  align = NULL,
  fmt = "\%.3f",
  hrule = NULL,
  notes = NULL,
  output = NULL,
  title = NULL,
  add_rows = NULL,
  add_columns = NULL,
  ...
)
}
\arguments{
\item{tab}{table body (data.frame)}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{fmt}{string which specifies how numeric values will be rounded. This
string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after
the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will
use exponential notation. See `?sprintf` for more options.}

\item{hrule}{position of horizontal rules (integer vector)}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{output}{filename or object type (string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item When a file name is supplied to the `output` argument, the table is written immediately to file. If you want to customize your table by post-processing it with functions provided by the `gt` or `kableExtra` packages, you need to choose a different output format (e.g., "gt", "latex", "html", "markdown"), and you need to save the table after post-processing using the `gt::gtsave`, `kableExtra::save_kable`, or `cat` functions.
}}

\item{title}{string}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See examples.}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{...}{all other arguments are passed to the `tidy` and `glance` methods
used to extract estimates from the model. For example, this allows users to
set `exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\description{
Factory to create tables in different output formats using standardized
inputs.
}
