% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsummary_wide.R
\name{modelsummary_wide}
\alias{modelsummary_wide}
\title{Summary Tables for Models with Grouped Coefficients}
\usage{
modelsummary_wide(
  models,
  output = "default",
  fmt = 3,
  estimate = "estimate",
  statistic = "std.error",
  vcov = NULL,
  conf_level = 0.95,
  stars = FALSE,
  coef_group = NULL,
  coef_map = NULL,
  coef_omit = NULL,
  coef_rename = NULL,
  gof_map = NULL,
  gof_omit = NULL,
  add_rows = NULL,
  align = NULL,
  notes = NULL,
  title = NULL,
  stacking = "horizontal",
  ...
)
}
\arguments{
\item{models}{a model or (optionally named) list of models}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "modelsummary_list", "gt", "kableExtra", "huxtable", "flextable".
\item To change the default output format, type \code{options(modelsummary_default = "latex")}, where \code{latex} can be any of the valid object types listed above.
\item Warning: the \code{output} argument \emph{cannot} be used when customizing tables with external packages.
\item See the 'Details' section below for more information.
}}

\item{fmt}{determines how to format numeric values
\itemize{
\item integer: the number of digits to keep after the period \code{format(round(x, fmt), nsmall=fmt)}
\item character: passed to the \code{sprintf} function (e.g., '\\%.3f' keeps 3 digits with trailing zero). See \code{?sprintf}
\item function: returns a formatted character string.
}}

\item{estimate}{string or \code{glue} string of the estimate to display (or a
vector with one string per model). Valid entries include any column name of
the data.frame produced by \code{get_estimates(model)}. Examples:
\itemize{
\item \code{"estimate"}
\item \code{"{estimate} ({std.error}){stars}"}
\item \code{"{estimate} [{conf.low}, {conf.high}]"}
}}

\item{statistic}{vector of strings or \code{glue} strings which select uncertainty
statistics to report vertically below the estimate. NULL omits all
uncertainty statistics.
\itemize{
\item "conf.int", "std.error", "statistic", "p.value", "conf.low", "conf.high",
or any column name produced by: \code{get_estimates(model)}
\item \code{glue} package strings with braces, such as:
\itemize{
\item \code{"{p.value} [{conf.low}, {conf.high}]"}
\item \code{"Std.Error: {std.error}"}
}
\item Note: Parentheses are added automatically unless the string includes \code{glue} curly braces \code{{}}.
\item Note: To report uncertainty statistics \emph{next} to coefficients, you can #'   supply a \code{glue} string to the \code{estimate} argument.
}}

\item{vcov}{robust standard errors and other manual statistics. The \code{vcov}
argument accepts five types of input (see the 'Details' and 'Examples'
sections below):
\itemize{
\item string, vector, or list of strings: "robust", "HC", "HC0", "HC1", "HC2", "HC3", "HC4", "HC4m", "HC5", "stata", or "classical" (alias "constant" or "iid").
\item formula or list of formulas with the cluster variable(s) on the right-hand side (e.g., ~clusterid).
\item function or list of functions which return variance-covariance matrices with row and column names equal to the names of your coefficient estimates (e.g., \code{stats::vcov}, \code{sandwich::vcovHC}).
\item list of \code{length(models)} variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
\item a list of length(models) vectors with names equal to the names of your coefficient estimates. See 'Examples' section below. Warning: since this list of vectors can include arbitrary strings or numbers, \code{modelsummary} cannot automatically calculate p values. The \code{stars} argument may thus use incorrect significance thresholds when \code{vcov} is a list of vectors.
}}

\item{conf_level}{confidence level to use for confidence intervals}

\item{stars}{to indicate statistical significance
\itemize{
\item FALSE (default): no significance stars.
\item TRUE: *=.1, **=.05, ***=.01
\item Named numeric vector for custom stars such as \code{c('*' = .1, '+' = .05)}
\item Note: a legend will not be inserted at the bottom of the table when the \code{estimate} or \code{statistic} arguments use "glue strings" with \code{{stars}}.
}}

\item{coef_group}{the name of the coefficient groups to use as columns (NULL
or character). If \code{coef_group} is NULL, \code{modelsummary} tries to guess the
correct coefficient group identifier. To be valid, this identifier must
be a column in the data.frame produced by \code{get_estimates(model)}.}

\item{coef_map}{character vector. Subset, rename, and reorder coefficients.
Coefficients omitted from this vector are omitted from the table. The order
of the vector determines the order of the table.  \code{coef_map} can be a named
or an unnamed character vector (see the Examples section below). If
\code{coef_map} is a named vector, its values define the labels that must appear
in the table, and its names identify the original term names stored in the
model object: \code{c("hp:mpg"="HPxM/G")}.}

\item{coef_omit}{string regular expression. Omits all matching coefficients
from the table using \code{grepl(perl=TRUE)}.}

\item{coef_rename}{named character vector or function which returns a named
vector. Values of the vector refer to the variable names that will appear
in the table. Names refer to the original term names stored in the model
object, e.g. c("hp:mpg"="hp X mpg") for an interaction term.}

\item{gof_map}{\itemize{
\item NULL (default): the \code{modelsummary::gof_map} dictionary is used for formatting, and all unknown statistic are included.
\item data.frame with 3 columns named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples' section below.
\item list of lists, each of which includes 3 elements named "raw", "clean", "fmt". Unknown statistics are omitted. See the 'Examples section below'.
}}

\item{gof_omit}{string regular expression. Omits all matching gof statistics from
the table (using \code{grepl(perl=TRUE)}).}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{align}{A character string of length equal to the number of columns in
the table.  "lcr" means that the first column will be left-aligned, the 2nd
column center-aligned, and the 3rd column right-aligned.}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{title}{string}

\item{stacking}{direction in which models are stacked: "horizontal" or
"vertical"}

\item{...}{all other arguments are passed through to the extractor and
table-making functions. This allows users to pass arguments directly to
\code{modelsummary} in order to affect the behavior of other functions behind
the scenes. Examples include:
\itemize{
\item \code{broom::tidy(exponentiate=TRUE)} to exponentiate logistic regression
\item \code{kableExtra::kbl(escape=FALSE)} to avoid escaping math characters in \code{kableExtra} tables.
\item \code{performance::model_performance(metrics="RMSE")} to select goodness-of-fit statistics to extract using the \code{performance} package (must have set \code{options(modelsummary_get="easystats")} first).
}}
}
\value{
a regression table in a format determined by the \code{output} argument.
}
\description{
\code{modelsummary_wide} summarizes models with grouped coefficients. For
example, these groups could correspond to levels of a multinomial logit
outcome variable, or to parameters of a GAMLSS model. This function's
arguments are the same as in \code{modelsummary}, except for the \code{coef_group} and
the \code{stacking} arguments.
}
