library(modelsummary)

test_that("dvnames adds names", {
    d <- data.frame(x = 1:10, y = 2:11)
    m1 <- lm(y~x, data = d)
    m2 <- lm(x~y, data = d)

    dvnout <- dvnames(list(m1,m2))

    nondvn <- list('y' = m1, 'x' = m2)

    expect_identical(dvnout, nondvn)
})

test_that("dvnames with single input", {
    d <- data.frame(x = 1:10, y = 2:11)
    m1 <- lm(y~x, data = d)

    dvnout <- dvnames(m1)

    nondvn <- list('y' = m1)

    expect_identical(dvnout, nondvn)
})

test_that("dvnames numbering", {
    d <- data.frame(x = 1:10, y = 2:11)
    m1 <- lm(y~x, data = d)
    m2 <- lm(x~y, data = d)

    dvnout <- dvnames(list(m1,m2), number = TRUE)

    nondvn <- list('y (1)' = m1, 'x (2)' = m2)

    expect_identical(dvnout, nondvn)
})

test_that("dvnames fill", {
    d <- data.frame(x = 1:10, y = 2:11)
    m1 <- lm(y~x, data = d)
    m2 <- lm(x~y, data = d)

    dvnout <- dvnames(list(m1,m2,1))

    nondvn <- list('y' = m1, 'x' = m2, 'Model' = 1)

    expect_identical(dvnout, nondvn)
})
