% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.var.R
\name{weighted.var}
\alias{weighted.var}
\title{Weighted univariate variance coping with missing values}
\usage{
weighted.var(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{a vector of data.}

\item{w}{a vector of positive weights (may not have missings where x is observed).}

\item{na.rm}{if \code{TRUE} remove missing values.}
}
\value{
The weighted variance of \code{x} with weights \code{w} (with missing values removed
when \code{na.rm = TRUE}).
}
\description{
This function is analogous to weighted.mean.
}
\details{
The weights are standardised such that \eqn{\sum_{observed} w_i} equals the number of observed
values in \eqn{x}. The function calculates \deqn{\sum_{observed} w_i(x_i -
weighted.mean(x, w, na.rm = TRUE))^2/((\sum_{observed} w_i) - 1)}
}
\examples{
x <- rnorm(100)
x[sample(1:100, 20)] <- NA
w <- rchisq(100, 2)
weighted.var(x, w, na.rm = TRUE)
}
\seealso{
\href{http://stat.ethz.ch/R-manual/R-devel/library/stats/html/weighted.mean.html}{weighted.mean}
}
\author{
Beat Hulliger
}
