% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcpw.R
\name{bcpw}
\alias{bcpw}
\title{Hamed (2009) Bias Corrected Prewhitening.}
\usage{
bcpw(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z-Value - Mann-Kendall Z-statistic after bias corrected prewhitening

Prewhitened Sen's Slope - Sen's slope of the prewhitened data

Sen's Slope - Sen's slope for the original data series 'x'

P-value - p-value after prewhitening

S - Mann-Kendall 'S' statistic

Var(s) - Variance of 'S'

Tau - Mann-Kendall's Tau
}
\description{
Hamed (2009) proposed a prewhitening technique in which the slope and lag-1 serial correltaion coefficient are simultaneously estimated.  The lag-1 serial correltaion coefficient is then corrected for bias before prewhitening.
}
\details{
Employs ordinary least squares (OLS) to simultaneously estimate the lag-1 serial correlation coefficient and slope of trend.  The lag-1 serial correlation coefficient is then bias corrected.
}
\examples{
x<-c(Nile)
bcpw(x)

}
\references{
Hamed, K. H. (2009). Enhancing the effectiveness of prewhitening in trend analysis of hydrologic data. Journal of Hydrology, 368: 143-155.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245-259. <doi:10.1017/CBO9781107415324.004>

van Giersbergen, N. P. A. (2005). On the effect of deterministic terms on the bias in stable AR models. Economic Letters, 89: 75-82.
}
