% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkttest.R
\name{mkttest}
\alias{mkttest}
\title{Mann-Kendall Trend Test of Time Series Data Without Modifications}
\usage{
mkttest(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Z  - Mann-Kendall Z statistic

Sen's slope  - Sen's slope

S  - Mann-Kendall S statistic

Var(s) - Variance of S

P-value  - Mann-Kendall p-value

Tau  - Mann-Kendall's Tau
}
\description{
The Mann-Kendall trend test is a nonparametric trend test used to identify monotonic trends present in time series data.
}
\details{
The Mann-Kendall trend test is a nonparametric trend tests which assuems no distribution of the data. The null hypothesis of the test is that there is no trend in the data and the alternative hypothesis is that the data represents a monotonic trend.
}
\examples{
x<-c(Nile)
mkttest(x)

}
\references{
Kendall, M. (1975). Rank Correlation Methods. Griffin, London, 202 pp.

Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3): 245-259.

Sen, P. K. (1968). Estimates of the Regression Coefficient Based on Kendall’s Tau. Journal of the American statistical Association, 63(324): 1379. <doi:10.2307/2285891>
}
