% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_mego.R
\name{EI}
\alias{EI}
\title{Constrained Expected Improvement}
\usage{
EI(x, model, control = NULL)
}
\arguments{
\item{x}{A vector representing the input for which one wishes to calculate EI.}

\item{model}{An object of class \code{\link{mkm}}. This \code{model} must have a single
objective (\code{model@m == 1}).}

\item{control}{An optional list of control parameters, some of them passed to
the EI function. One can control:
  \describe{
   \item{\code{minimization}}{logical specifying if EI is used in minimization or in maximization
   (default: \code{TRUE})}
   \item{\code{plugin}}{optional scalar, if not provided, the minimum (or maximum) of the current
    feasible observations. If there isn't any feasible design plugin is set to \code{NA} and the
    algorithm returns the value of the probability of constraints be met.}
   \item{\code{envir}}{optional environment specifying where to assign intermediate values.
    Default: \code{NULL}.}
  }}
}
\description{
This functions extends the EI function supplied by the package
archive package DiceOptim. This extension allows usage of multiple
expensive constraints. The constraints are passed to the revamped EI function
embedded inside the \code{\link{mkm}} object. Currently low-cost (explicit)
constraints are not allowed.
}
\details{
The way that the constraints are handled are based on the probability of
feasibility. The strong assumption here is that the cost functions and the
constraints are uncorrelated. With that assumption in mind, a simple
closed-form solution can be derived that consists in the product of the
probability that each constraint will be met and the expected improvement of
the objective. Another important consideration is that, by default, the value
of the plugin passed to the EI is the best
\emph{feasible} observed value.
}
\examples{
# --------------------------------------------
# Branin-Hoo function (with simple constraint)
# --------------------------------------------
n <- 10
d <- 2
doe <- replicate(d,sample(0:n,n))/n
fun_cost <- DiceKriging::branin
fun_cntr <- function(x) 0.2 - prod(x)
fun <- function(x) return(cbind(fun_cost(x),fun_cntr(x)))
res <- t(apply(doe, 1, fun))
model <- mkm(doe, res, modelcontrol = list(objective = 1, lower=c(0.1,0.1)))
grid <- expand.grid(seq(0,1,,25),seq(0,1,,25))
ei <- apply(grid, 1, EI, model) # this computation may take some time
contour(matrix(ei,25))
points(model@design, col=ifelse(model@feasible,'blue','red'))
points(grid[which.max(ei),], col='green')
}
\references{
Forrester, A., Sobester, A., & Keane, A. (2008).
  \emph{Engineering design via surrogate modelling: a practical guide.} John
  Wiley & Sons.
}
