% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moonboot.R
\name{mboot.ci}
\alias{mboot.ci}
\title{m-Out-of-n Bootstrap Confidence Intervals}
\usage{
mboot.ci(boot.out, conf = 0.95, tau = NULL, types = "all", ...)
}
\arguments{
\item{boot.out}{The simulated bootstrap distribution from the \code{mboot} call.}

\item{conf}{The confidence level.}

\item{tau}{Function that returns the scaling factor tau in dependence of n. If \code{NULL}, \code{estimate.tau} is used to estimate \code{tau}.}

\item{types}{The types of confidence intervals to be calculated. The value can be 'all' for all types, or a
subset of \code{c("basic", "norm", "sherman")}.}

\item{...}{When \code{tau} is omitted, the additional parameters are passed to \code{statistic} during estimation of \code{tau}.}
}
\value{
A list of confidence intervals for the given types.
}
\description{
Estimates the confidence interval using the methods provided by \code{types}.
\code{tau} must be a function that calculates teh scaling factor
tau(n) for a given n. If \code{tau} is not provided, it is estimated
with \code{estimate.tau} using the default settings of this function.
}
\details{
As estimating the scaling factor tau(n) can be unreliable, it is recommended
to explicitly provide \code{tau}. Otherwise it is estimated with
\code{estimate.tau}. To specify additional arguments for
\code{estimate.tau}, call this function directly and use its return value
as \code{tau} argument. For the type \code{sherman}, \code{tau} is not
needed and its value is ignored.

The following methods to compute teh confidence intervals are supported
through the parameter \code{type}:

\describe{\item{basic:}{
This method works for all estimators and computes the interval directly from the quantiles of the m-out-of-n bootstrap distribution.}
\item{norm:}{
This method only works for normally distributed estimators. It estimates the variance with the m-out-of-n bootstrap and then computes te interval with the quantiles of teh standard normal distribution.}
\item{sherman:}{
This method does not scale the interval with tau(m)/tau(n) and thus is too wide. To avoid over-coverage, this is compensated by centering it randomly around the point estimators of one of the m-out-of-n bootstrap samples. Although this results on average in the nominal coverage probability, the interval is less accurate than the other intervals and should be used only as a last resort if the scaling factor tau is neither known, nor estimatable.}}
}
\examples{
data <- runif(1000)
estimate.max <- function(data, indices) {return(max(data[indices]))}
tau <- function(n){n} # convergence rate (usually sqrt(n), but n for max) 
boot.out <- mboot(data, estimate.max, R = 1000, m = 2*sqrt(NROW(data)), replace = FALSE)
cis <- mboot.ci(boot.out, 0.95, tau, c("all"))
ci.basic <- cis$basic
print(ci.basic)

}
\references{
Politis D.N. and Romano J.P. (1994) Large sample confidence regions
based on subsamples under minimal assumptions. \emph{The Annals of Statistics}, 22(4):2031-2050, \doi{10.1214/aos/1176325770}

Sherman M. and Carlstein E. (2004) Confidence intervals based on estimators with unknown rates of convergence.
\emph{Computional statistics & data analysis}, 46(1):123-136.

Dalitz C. and Lögler M. (2024) moonboot: An R Package Implementing m-out-of-n Bootstrap Methods \doi{10.48550/arXiv.2412.05032}
}
\seealso{
mboot estimate.tau
}
\keyword{~htest}
