\name{track}
\alias{track}
\title{
Plot track of planets
}
\description{
To plot tracts of planets during to dates.
}
\usage{
track(ephem, mag = 7, edge = 0.2, cex.star = 1,xlab = "Right Ascension",
           ylab = expression(paste("Declination", degree)), col.track = "red", 
          interval.lab = 15, lwd.track = 2, grid = TRUE, bright.lab = TRUE,
          bright, starcat,...) 
}
\arguments{
  \item{ephem}{
Equatorial coordinates of celestial objects as generated. see \code{\link{planet}} for more information.
}
  \item{mag}{
Magnitude of stars to be plot on the background.
}
  \item{edge}{
Numeric, the edge extention of the plots from each side of the ploting margin.
}
  \item{cex.star}{
Numeric, indicating the point size of the stars to be ploted on the background. 
}
  \item{xlab}{
label for the x axis.
}
  \item{ylab}{
label for the y axis.
}
  \item{col.track}{
color of the planet's track .
}
  \item{interval.lab}{
Time interval for the label.
}
  \item{lwd.track}{
Line width of the planet's track.
}
  \item{grid}{
Whether the grid of coordinate's should be drawn.
}
  \item{bright.lab}{
Whether to draw the labels of bright stars on the plot.
}
  \item{bright}{
Data frame for bright stars
}
  \item{starcat}{
Star catalogue used in plotting.
}
  \item{\dots}{
Other specified methods to draw the plot.
}
}
\details{
User may employ this function when she/he wants to see the tracks of certain planet during time 1 to time 2. The input data should be generated by \code{\link{planet}},or \code{\link{planet}} related functions such as \code{\link{mercury}},\code{\link{mars}},\code{\link{saturn}}. User may define her/his own celestral objects and plot the tracks using this function. 
}
\value{
NULL
}
\references{

http://www.clearskyinstitute.com/xephem/

http://www.alcyone.de/

}
\author{
Jinlong Zhang \email{jinlongzhang01@gmail.com}
}

\examples{

# Beijing
options(longitude = 116.433, latitude = 39.874)

### plot the background of sky chart
data(bright)
data(starcat)

ephem.mercury <- mercury(jd(2010,1,1,length = 365))
track(ephem.mercury, mag = 4, interval.lab = 30, bright.lab = TRUE, 
	starcat = starcat, bright = bright)

ephem.mercury <- mercury(jd(2010,7,30,length = 60))
track(ephem.mercury, mag = 7, interval.lab = 10, cex.star = 2, starcat = starcat, bright = bright)

ephem.venus <- venus(jd(2011,4,30,length = 100))
track(ephem.venus, col.track = "blue", lwd = 3, mag = 5, starcat = starcat, bright = bright)

ephem.mars <- mars(jd(2010,8,30,length = 100))
track(ephem.mars, cex.star = 1.5, grid = FALSE, starcat = starcat, bright = bright)

ephem.jupiter <- jupiter(jd(2010,9,22,length = 100))
track(ephem.jupiter, cex.star = 1.5, col.track = "black" , starcat = starcat, bright = bright)

ephem.saturn <- saturn(jd(2011,9,22,length = 100))
track(ephem.saturn, starcat = starcat, bright = bright)

ephem.uranus <- uranus(jd(2008,8,1,length = 100))
track(ephem.uranus, starcat = starcat, bright = bright)

}

\keyword{ track }

