% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mop.R
\name{mop}
\alias{mop}
\title{Analysis of extrapolation risks using the MOP metric}
\usage{
mop(m, g, type = "basic",  calculate_distance = FALSE,
    where_distance = "in_range", distance = "euclidean",
    scale = FALSE, center = FALSE, fix_NA = TRUE,
    percentage = 1, comp_each = 2000, rescale_distance = FALSE,
    parallel = FALSE, n_cores = NULL, progress_bar = TRUE)
}
\arguments{
\item{m}{a \code{SpatRaster} or matrix of variables representing a set of
conditions of reference (e.g., the set of conditions in which a model was
calibrated). If a matrix is used, each column represents a variable.}

\item{g}{a \code{SpatRaster} or matrix of variables representing a set of
conditions of interest for which dissimilarity values and non-analogous
conditions will be detected (e.g., conditions in which a model is projected).
Variable names must match between \code{m} and \code{g}.}

\item{type}{\code{character}, type of MOP analysis to be performed. See \code{Details}
for options.}

\item{calculate_distance}{\code{logical}, whether to calculate distances
(dissimilarities) between \code{m} and \code{g}. The default, FALSE, runs
rapidly and does not assess dissimilarity levels.}

\item{where_distance}{\code{character}, where to calculate distances, considering
how conditions in \code{g} are positioned in comparison to the range of
conditions in \code{m}. See \code{Details} for options.}

\item{distance}{\code{character}, which distances are calculated, \code{euclidean} or
\code{mahalanobis}. Valid if \code{calculate_distance = TRUE}.}

\item{scale}{scaling options, \code{logical} or \code{numeric-alike} as in
\code{\link[base]{scale}}.}

\item{center}{\code{logical} or \code{numeric-alike} center options as in
\code{\link[base]{scale}}.}

\item{fix_NA}{\code{logical}, whether to fix layers so cells with NA values
are the same in all layers. Setting to FALSE may save time if the
rasters are big and have no NA matching problems.}

\item{percentage}{\code{numeric}, percentage of \code{m} closest conditions used
to derive mean environmental distances to each combination of conditions in
\code{g}.}

\item{comp_each}{\code{numeric}, number of combinations in \code{g} to be used for
distance calculations at a time. Increasing this number requires more RAM.}

\item{rescale_distance}{\code{logical}, whether or not to re-scale distances 0-1.
Re-scaling prevents comparisons of dissimilarity values obtained from runs
with different values of \code{percentage}.}

\item{parallel}{\code{logical}, whether calculations should be performed in
parallel using \code{n_cores} of the computer. Using this option will speed
up the analysis but will demand more RAM.}

\item{n_cores}{\code{numeric}, number of cores to be used in parallel processing.
If \code{parallel = TRUE} and \code{n_cores = NULL} (all CPU cores on current host - 1)
will be used.}

\item{progress_bar}{\code{logical}, whether to show a progress bar.}
}
\value{
A object of class \code{\link{mop_results}} containing:
\itemize{
\item \strong{summary} - a list with details of the data used in the analysis:
\itemize{
\item \emph{variables} - names of variables considered.
\item \emph{type} - type of MOP analysis performed.
\item \emph{scale} - value according to the argument \code{scale}.
\item \emph{center} - value according to the argument \code{center}.
\item \emph{calculate_distance} - value according to the argument
\code{calculate_distance}.
\item \emph{distance} - option regarding distance used.
\item \emph{percentage} - percentage of \code{m} used as reference for
distance calculation.
\item \emph{rescale_distance} - value according to the argument
\code{rescale_distance}.
\item \emph{fix_NA} - value according to the argument \code{fix_NA}.
\item \emph{N_m} - total number of elements (cells with values or valid
rows) in \code{m}.
\item \emph{N_g} - total number of elements (cells with values or valid
rows) in \code{g}.
\item \emph{m_ranges} - matrix with ranges of variables in reference conditions
(\code{m}).
}
\item \strong{mop_distances} - if \code{calculate_distance} = TRUE, a SpatRaster or
vector with distance values for the set of interest (\code{g}). Higher values
represent greater dissimilarity compared to the set of reference (\code{m}).
\item \strong{mop_basic} - a SpatRaster or vector, for the set of interest,
representing conditions in which at least one of the variables is
non-analogous to the set of reference. Values should be: 1 for non-analogous
conditions, and NA for conditions inside the ranges of the reference set.
\item \strong{mop_simple} - a SpatRaster or vector, for the set of interest,
representing how many variables in the set of interest are non-analogous to
those in the reference set. NA is used for conditions inside the ranges of
the reference set.
\item \strong{mop_detailed} - a list containing:
\itemize{
\item \emph{interpretation_combined} - a data.frame to help identify combinations
of variables in \emph{towards_low_combined} and \emph{towards_high_combined} that
are non-analogous to \code{m}.
\item \emph{towards_low_end} - a SpatRaster or matrix for all variables
representing where non-analogous conditions were found towards low values
of each variable.
\item \emph{towards_high_end} - a SpatRaster or matrix for all variables
representing where non-analogous conditions were found towards high
values of each variable.
\item \emph{towards_low_combined} - a SpatRaster or vector with values
representing the identity of the variables found to have non-analogous
conditions towards low values. If vector, interpretation requires the use
of the data.frame \emph{interpretation_combined}.
\item \emph{towards_high_combined} - a SpatRaster or vector with values
representing the identity of the variables found to have non-analogous
conditions towards high values. If vector, interpretation requires the
use of the data.frame \emph{interpretation_combined}.
}
}
}
\description{
Analysis to calculate the mobility-oriented parity metric and other
sub-products to represent dissimilarities and non-analogous conditions
when comparing a set of reference conditions (M; \code{m}) against another
set of conditions of interest (G; \code{g}).
}
\details{
\code{type} options return results that differ in the detail of how non-analogous
conditions are identified.
\itemize{
\item \strong{basic} - makes calculation as proposed by Owens et al. (2013)
\url{doi:10.1016/j.ecolmodel.2013.04.011}.
\item \strong{simple} - calculates how many variables in the set of interest are
non-analogous to those in the reference set.
\item \strong{detailed} - calculates five additional extrapolation metrics. See
\code{mop_detailed} under \code{Value} below for full details.
}

\code{where_distance} options determine what values should be used to calculate
dissimilarity
\itemize{
\item \strong{in_range} - only conditions inside \code{m} ranges
\item \strong{out_range} - only conditions outside \code{m} ranges
\item \strong{all} - all conditions
}

When the variables used to represent conditions have different units,
scaling and centering are recommended. This step is only valid when Euclidean
distances are used.
}
\examples{
# data
reference_layers <- terra::rast(system.file("extdata", "reference_layers.tif",
                                            package = "mop"))

layers_of_interest <- terra::rast(system.file("extdata",
                                              "layers_of_interest.tif",
                                              package = "mop"))

# analysis
mop_res <- mop(m = reference_layers, g = layers_of_interest)

summary(mop_res)
}
\seealso{
\code{\link{mop_distance}}, \code{\link{out_range}}
}
