% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{align_sentence}
\alias{align_sentence}
\title{Align x_position of words according to common words between two sentences}
\usage{
align_sentence(df, s_id = "sentence", term = "term", x_pos = "x")
}
\arguments{
\item{df}{A dataframe analysed by MeCab}

\item{s_id}{A String to specify sentence}

\item{term, x_pos}{A String to specify term and x_position}
}
\value{
A dataframe
}
\description{
Align x_position of words according to common words between two sentences
}
\examples{
library(magrittr)
library(dplyr)
library(purrr)
library(ggplot2)
  # settings
s1 <- 1:4
s2 <- 3:6
s3 <- 3:6
s4 <- 7:10
s_order <- list(s1, s2, s3, s4)
s_id <- "sentence"
term <- map2(list(letters), s_order, `[`)
df <- tibble::tibble(
        {{s_id}} := rep(seq_along(term), purrr::map_int(term, length)),
        term = unlist(term),
        x = seq_along(term))
  # show dataframe
df
align_sentence(df)
  # plot
df \%>\%
  align_sentence() \%>\%
  dplyr::mutate(`:=`({{s_id}}, .data[[s_id]] + max(.data[[s_id]]))) \%>\%
  dplyr::bind_rows(df) \%>\%
  ggplot2::ggplot(aes(x, .data[[s_id]], label = term)) + 
    ggplot2::geom_text() + 
    ggplot2::theme_bw()

}
