% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.LCx.R
\name{plot.LCx}
\alias{plot.LCx}
\title{Plotting method for \code{LCx} objects}
\usage{
\method{plot}{LCx}(x, xlab = "Concentration",
  ylab = "Survival rate \\n median and 95 CI", main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{LCx}.}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Concentration}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Survival rate median and 95 CI}.}

\item{main}{A main title for the plot.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\description{
This is the generic \code{plot} S3 method for the
\\code{LCx} class. It plots the survival rate as a function of concentration.
}
\examples{

# (1) Load the data
data("propiconazole")

# (2) Create an object of class 'survData'
dataset <- survData(propiconazole)

\dontrun{
# (3) Run the survFit function with model_type SD (or IT)
out_SD <- survFit(dataset, model_type = "SD")

# (4) estimate LC50 at time 4
LCx_SD <- LCx(out_SD, X = 50, time_LCx = 4)

# (5) plot the object of class 'LCx'
plot(LCx_SD)
}

}
\keyword{plot}
