% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{mWorldMap}
\alias{mWorldMap}
\title{Make a world map with \code{ggplot2}}
\usage{
mWorldMap(data, key, fill = NULL, plot = c("borders", "frame", "none"))
}
\arguments{
\item{data}{A dataframe with countries as cases}

\item{key}{The column name in the \code{data} that holds
the unique names of each country}

\item{fill}{A variable in the \code{data} used to specify the fill
color of countries in the map (note: if \code{fill} is not null, then
\code{plot} cannot be set to "none")}

\item{plot}{The plot desired for the output. \code{plot} = "none"
returns the merged data that is the result of merging the \code{data}
and the dataframe with the geographical coordinate information;
\code{plot} = "frame" returns an empty (unplottable) ggplot object;
\code{plot} = "border" (the default) returns a ggplot object with
one geom_polygon layer that shows the borders of the countries}
}
\description{
\code{mWorldMap} takes in one dataframe that includes information
about different countries. It merges this dataframe with a dataframe
that includes geographical coordinate information. Depending on the
arguments passed, it returns this data or a ggplot object constructed
with the data.
}
\examples{
\dontrun{
gdpData <- CIAdata("GDP")      # load some world data

mWorldMap(gdpData, key="country", fill="GDP")

gdpData <- gdpData \%>\% mutate(GDP5 = ntiles(-GDP, 5, format="rank")) 
mWorldMap(gdpData, key="country", fill="GDP5")

mWorldMap(gdpData, key="country", plot="frame") +
geom_point()

mergedData <- mWorldMap(gdpData, key="country", plot="none")

ggplot(mergedData, aes(x=long, y=lat, group=group, order=order)) +
geom_polygon(aes(fill=GDP5), color="gray70", size=.5) + guides(fill=FALSE)  
}
}

