% Generated by roxygen2 (4.0.2): do not edit by hand
\name{chisq}
\alias{chisq}
\alias{chisq.default}
\alias{chisq.htest}
\title{Extract Chi-squared statistic}
\usage{
chisq(x, ...)

\method{chisq}{htest}(x, ...)

\method{chisq}{default}(x, ...)
}
\arguments{
\item{x,...}{Either an object of class \code{"htest"} coming from a Chi-squared test or
the inputs to \code{\link{chisq.test}}.}
}
\description{
Extract Chi-squared statistic
}
\examples{
if(require(mosaicData)) {
  Mites.table <- tally( ~ outcome + treatment, data=Mites )
  Mites.table
  chisq.test(Mites.table)
  chisq(Mites.table)
  chisq(chisq.test(Mites.table))
  ## Randomization test.  Increase replications to decrease Monte Carlo error.
  do(3) * chisq( tally( ~ outcome + shuffle(treatment),  data=Mites ) )
  Mites.rand <- do(1000) * chisq( tally( ~ outcome + shuffle(treatment),  data=Mites ) )
  tally( ~(X.squared >= chisq(Mites.table)), data=Mites.rand, format="proportion")
}
}
\seealso{
\code{\link{stat}}
}

