% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xqqmath.R
\name{xqqmath}
\alias{xqqmath}
\alias{panel.xqqmath}
\title{Augmented version of \code{qqmath}}
\usage{
xqqmath(x, data = NULL, panel = "panel.xqqmath", ...)

panel.xqqmath(x, qqmathline = !(fitline || idline), idline = FALSE,
  fitline = NULL, slope = NULL, intercept = NULL,
  overlines = FALSE, groups = NULL, ...,
  col.line = trellis.par.get("add.line")$col, pch = 16, lwd = 2,
  lty = 2)
}
\arguments{
\item{x, data, panel, xqqmath, \dots}{as in \code{\link[lattice:qqmath]{lattice::qqmath()}}}

\item{qqmathline}{a logical: should line be displayed passing through first and third quartiles?}

\item{idline}{a logical; should the line y=x be added to the plot?}

\item{fitline}{a logical; should a fitted line be added to plot?  Such a line will use \code{slope}
and \code{intercept} if provided, else the standard deviation and mean of the data.
If \code{slope} is specified, the line will be added unless \code{fitline} is
\code{FALSE}.}

\item{slope}{slope for added line}

\item{intercept}{intercept for added line}

\item{overlines}{a logical: should lines be on top of qq plot?}

\item{groups, pch, lwd, lty}{as in lattice plots}

\item{col.line}{color to use for added lines}
}
\value{
a trellis object
}
\description{
Augmented version of \code{qqmath}
}
\examples{
x <- rnorm(100)
xqqmath( ~ x)                  # with quartile line
xqqmath( ~ x, fitline = TRUE)  # with fitted line
xqqmath( ~ x, idline = TRUE)   # with y = x
x <- rexp(100, rate = 10)
xqqmath( ~ x, distribution = qexp)     # with quartile line
xqqmath( ~ x, distribution = qexp, slope = 1/10) 
xqqmath( ~ x, distribution = qexp, slope = mean(x)) 
}
