% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateODE.R
\name{integrateODE}
\alias{integrateODE}
\title{Integrate ordinary differential equations}
\usage{
integrateODE(...)
}
\arguments{
\item{\dots}{A dynamics object (see \code{makeODE()}) and/or arguments giving additional formulas for dynamics in other variables,
assignments of parameters, assignments of initial conditions, the start and end times of the
integration (through \code{domain()}), and the step size (through \verb{dt=}).}
}
\value{
a list with splined function of time for each dynamical variable
}
\description{
A formula interface to integration of an ODE with respect to "t"
}
\details{
The equations must be in first-order form.  Each dynamical equation uses
a formula interface with the variable name given on the left-hand side of the
formula, preceded by a \code{d}, so use \code{dx~-k*x} for exponential decay.
All parameters (such as \code{k}) must be assigned numerical values in the
argument list.  All dynamical variables must be assigned initial conditions in the
argument list.  The returned value will be a list with one component named after each
dynamical variable.  The component will be a spline-generated function of \code{t}.
}
\examples{
soln = integrateODE(dx~r*x*(1-x/k), k=10, r=.5, domain(t=0:20), x=1)
soln$x(10)
soln$x(30) # outside the time interval for integration
traj_plot(x(t)~t, soln, domain(t=0:10)) 
soln2 = integrateODE(dx~y, dy~-x, x=1, y=0, domain(t=0:10))
traj_plot(y(t)~t, soln2)
SIR <- makeODE(dS~ -a*S*I, dI ~ a*S*I - b*I, a=0.0026, b=.5, S=762, I=1)
epi = integrateODE(SIR, domain(t=0:20)) 
traj_plot(I(t) ~ t, epi)
}
