% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{list_shares}
\alias{list_shares}
\title{List MotherDuck Shares}
\usage{
list_shares(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \link[tibble:tibble]{tibble::tibble} containing details of available shares if
the connection is an MD connection or an empty tibble if not
}
\description{
The \code{list_shares()} function provides a convenient wrapper around the
MotherDuck SQL command \verb{LIST SHARES;}. It validates that the supplied
connection is an active MotherDuck connection before executing the query.
If the connection is not valid, the function returns \code{0} instead of a table.
}
\details{
MotherDuck supports object sharing, which allows users to list and access
data shared between accounts. This function helps programmatically inspect
available shares within an authenticated MotherDuck session.
}
\examples{
\dontrun{
# Connect to MotherDuck
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))

# List shares
list_shares(con)

# Disconnect
DBI::dbDisconnect(con)
}

}
\seealso{
Other db-list: 
\code{\link{list_all_databases}()},
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()}
}
\concept{db-list}
