% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{upload_database_to_md}
\alias{upload_database_to_md}
\title{Upload a Local Database to MotherDuck}
\usage{
upload_database_to_md(.con, from_db_name, to_db_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{from_db_name}{The local database name to copy from.}

\item{to_db_name}{The target MotherDuck database to create/overwrite.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: creates the target database and copies all objects; prints a CLI
action report.
}
\description{
Creates a new database on MotherDuck (if it does not exist) and copies
all objects from an existing local database into it using the
\verb{COPY FROM DATABASE} command.
}
\details{
\itemize{
\item Runs \verb{CREATE DATABASE <to_db_name>} if the target database does not exist.
\item Then runs \verb{COPY FROM DATABASE <from_db_name> TO <to_db_name>} to copy all
objects (tables, views, etc.) from the local database.
\item Prints a CLI status report (connection, user, current DB) after completion.
}
}
\examples{
\dontrun{
con_db <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
create_table(.con=con_db,.data=mtcars,database_name="memory",schema_name="main",table_name="mtcars")
con_md <- connect_to_motherduck()

upload_database_to_md(con_md, from_db_name = "memory", to_db_name = "analytics")
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()}
}
\concept{db-manage}
