% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitData.plot.R
\name{traitData.plot}
\alias{traitData.plot}
\title{plot a univariate continuous trait data on a phylogeny}
\usage{
traitData.plot(y, phy, col.label = "red", col.tree = "black",
  cex.plot = 0.7, include.hist = F)
}
\arguments{
\item{y}{A matrix of trait values with taxon names as rownames.}

\item{phy}{An object of class "phylo" (see ape package).}

\item{col.label}{colour labels for the traits at the tips and in the histogram}

\item{col.tree}{colour for the edge labels on the tree}

\item{cex.plot}{Numeric. The size of labels for the histogram axis labels}

\item{include.hist}{Logical. Include a histrogram alongside the plot of the tree?}
}
\value{
A plot with the trait values shown at the tips, and a histrogram of the trait values
}
\description{
Plots a phylogeny with lines representing the value of a continuous trait
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
traitData.plot(y=male.length, phy)
}
\author{
Mark Puttick
}
