% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.plot.R
\name{mcmc.plot}
\alias{mcmc.plot}
\title{plot the output from transformPhylo.MCMC}
\usage{
mcmc.plot(
  mcmc.input,
  y.limit = NULL,
  x.limit = NULL,
  label.text = NULL,
  cex.axis = 1,
  cex.labels = 0.7,
  col.hist = "green4",
  col.trace = "navy"
)
}
\arguments{
\item{mcmc.input}{an object of class "mcmc.motmot" output from \code{\link{transformPhylo.MCMC}}}

\item{y.limit}{the limits for the y axes for the plots}

\item{x.limit}{the limits for the x axes for the plots}

\item{label.text}{the labels for the two plots defaults to '(a)' etc., for the histogram and '(b)' etc., for the trace plot}

\item{cex.axis}{character expansion for the plot axis labels}

\item{cex.labels}{character expansion for the plot axis names}

\item{col.hist}{colour for the histogram bars}

\item{col.trace}{colour for the trace plot}
}
\value{
Two plots showing the histogram of the estimated parameter value and a trace of the MCMC estimation
}
\description{
Plots a histogram of the estimated parameter and a trace of the results
}
\examples{
library(motmot)
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
phy.clade <- extract.clade(phy, 182)
male.length.clade <- as.matrix(male.length[match(phy.clade$tip.label, rownames(male.length)),])
## not run
# please note, this model will be need to run for longer to achieve convergence
# lambda.mcmc <- transformPhylo.MCMC(y=male.length.clade, phy=phy.clade, 
# model="lambda", mcmc.iteration=100, burn.in=0.1)
# mcmc.plot(lambda.mcmc)
}
\author{
Mark Puttick
}
