% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_move.R
\name{mt_as_move2}
\alias{mt_as_move2}
\alias{mt_as_move2.sf}
\alias{mt_as_move2.data.frame}
\alias{mt_as_move2..MoveTrack}
\title{Create a new move2 object}
\usage{
mt_as_move2(x, ...)

\method{mt_as_move2}{sf}(x, time_column, track_id_column, track_attributes = "", ...)

\method{mt_as_move2}{data.frame}(x, time_column, track_id_column, track_attributes = "", ...)

\method{mt_as_move2}{.MoveTrack}(x, ...)
}
\arguments{
\item{x}{A \code{data.frame}, \code{sf}, \code{Move} or \code{MoveStack} object}

\item{...}{Additional arguments passed to \code{\link[sf]{st_as_sf}} if \code{x} is a \code{data.frame}, see the details below
for more information}

\item{time_column}{The name of the column in \code{x} containing timestamps}

\item{track_id_column}{The name of the column in \code{x} containing the track identities}

\item{track_attributes}{The name(s) of the column(s) that contain track level attributes}
}
\value{
A \code{move2} object
}
\description{
Create a new move2 object from a \code{data.frame}, \code{sf}, \code{Move} or \code{MoveStack} object
}
\details{
Frequently used arguments to \code{\link[sf]{st_as_sf}} are:
\itemize{
\item \code{coords} a character vector indicating the columns used as coordinates, the length is generally two, for \code{x} and
\code{y}, but can also be more if \code{z} is included
\item \code{sf_column_name} if a geometry column is present the name of the geometry column to use as coordinates as a
character scalar
\item \code{crs} the coordinate reference system to use, either as character, number or a \code{crs} object for more details see
\code{\link[sf]{st_crs}}
\item \code{na.fail} normally when the coordinate columns are converted to spatial points \code{NA} values cause an error, if set
to \code{FALSE} empty points are allowed
}
}
\examples{
## create a move2 object from a data.frame and defining projection
n <- 5
data <- data.frame(
  x = cumsum(rnorm(n)), y = cumsum(rnorm(n)),
  time = seq(n), track = "a"
)
mt_as_move2(data,
  coords = c("x", "y"), time_column = "time",
  track_id_column = "track"
) |> sf::st_set_crs(4326L)

## Dealing with empty coordinates:
## If the data frame contains NA coordinates, the coords argument in sf
## will fail. An alternative is to first create an sfc column,
## or to use the na.fail argument
nn <- 3
data <- data.frame(
  x = c(cumsum(rnorm(n)), rep(NA, nn)), y = c(cumsum(rnorm(n)), rep(NA, nn)),
  time = seq(n + nn), track = "a",
  sensor = c(rep("sensor1", n), rep("sensor2", nn)),
  sensor2values = c(rep(NA, n), runif(nn))
)
mt_as_move2(data,
  coords = c("x", "y"),
  na.fail = FALSE,
  time_column = "time",
  track_id_column = "track"
)

## create a move2 object from a sf object
data$geometry <- sf::st_sfc(apply(data[, c("x", "y")], 1, sf::st_point, simplify = FALSE))
mt_as_move2(data,
  sf_column_name = c("geometry"), time_column = "time",
  track_id_column = "track"
)

}
\seealso{
Other move2-convert: 
\code{\link{to_move}()}
}
\concept{move2-convert}
