% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_azimuth.R
\name{mt_azimuth}
\alias{mt_azimuth}
\alias{mt_turnangle}
\title{Calculate azimuths or turn angles}
\usage{
mt_azimuth(x, units)

mt_turnangle(x, units)
}
\arguments{
\item{x}{a \code{move2} object. Timestamps must be ordered within tracks and only contain location data and
it must be in a geographic coordinate system or without a coordinate reference system (See 'Details').}

\item{units}{Optional. Valid values are \code{character}, \code{symbolic_units} or \code{units}, for more details see the \code{value} argument of \link[units:units]{units::as_units}. If no units are stated (default) the function flexibly determines the units to return. Fixing the units can be useful if specific return units are for example required for subsequent functions. This argument only takes effect if the initial return value already has units.}
}
\value{
A vector of angles, currently default is in radians (between \code{-pi} and \code{pi}).\cr

In \code{mt_azimuth} north is represented by 0, positive values are movements towards the east, and negative values
towards the west. The last value for each track will be \code{NA}.

In \code{mt_turnangle} negative values are left turns and positive right turns. The first and the last value for each
track will be \code{NA}.
}
\description{
\itemize{
\item \code{mt_azimuth}: calculates the heading/azimuth/direction of movement of each segment between consecutive locations
of a track.
\item \code{mt_turnangle}: calculates the relative angle between consecutive segments.
}
}
\details{
\code{mt_is_time_ordered_non_empty_points} can be used to check if the timestamps are ordered and if the object only
contains location data. To omit empty locations use e.g. \code{dplyr::filter(x,!sf::st_is_empty(x))}.

Currently the calculation of both angles is only implemented for data in a geographic coordinate system and data
without coordinates reference system. To reproject the data into long/lat use e.g.
\code{sf::st_transform(x, crs="EPSG:4326")}

Azimuths for geographic coordinates are calculated using \code{\link[lwgeom:st_geod_azimuth]{lwgeom::st_geod_azimuth()}}. The angles are relative to
the North pole.
}
\examples{
x <- mt_read(mt_example())[330:340, ]
mt_azimuth(x)
mt_turnangle(x)
}
\seealso{
Other track-measures: 
\code{\link{mt_distance}()},
\code{\link{mt_time}()}
}
\concept{track-measures}
