% Generated by roxygen2 (4.0.1): do not edit by hand
\name{forceScheme}
\alias{forceScheme}
\title{Force Scheme}
\usage{
forceScheme(d, initial = NULL, maxIt = 50, tol = 0.1)
}
\arguments{
\item{d}{A dissimilarity structure such as that returned by dist or a full
symmetric matrix containing the dissimilarities.}

\item{initial}{A initial 2D configuration (optional). A random configuration
will be created when omitted.}

\item{maxIt}{The maximum number of iterations that the method will run.}

\item{tol}{The tolerance for the accumulated error between iterations. Set it
to 0 to guarantee it will run maxIt times.}
}
\value{
The 2D representation of the data.
}
\description{
Create a 2D representation of the data based on a dissimilarity matrix. A few
modifications have been made in relation to the method described in the
literature: shuffled indices are used to minimize the order dependency
factor, only a fraction of delta is used for better stability and a tolerance
factor was introduced as a second stop criterion.
}
\examples{
result = forceScheme(eurodist)
}
\references{
Eduardo Tejada, Rosane Minghim, Luis Gustavo Nonato: On improved
  projection techniques to support visual exploration of multi-dimensional
  data sets. Information Visualization 2(4): 218-231 (2003)
}
\seealso{
\code{\link[stats]{dist}} (stats) and \code{\link[proxy]{dist}}
  (proxy) for d computation
}

