#' @include pedigreeGraph-class.R
#' @title Plot the graph of a pedigree
#' @description Plot the graph of a pedigree
#' @details Plot the graph of a pedigree, after the graph has been generated by \code{\link{pedigreeToGraph}}
#' @param x pedigree graph to plot
#' @param y unused
#' @param ... Other options to plot.igraph
#' @return None
#' @seealso \code{\link{pedigreeToGraph}}
setMethod(f = "plot", signature = "pedigreeGraph", definition = function(x, y, ...)
{
	igraph::plot.igraph(x@graph, layout = x@layout, vertex.frame.color=NA, edge.arrow.mode="-", frame = 0, margin=0, ...)
})
