% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{moving_average}
\alias{moving_average}
\title{Moving average for values in an mpathsenser database}
\usage{
moving_average(
  db,
  sensor,
  participant_id,
  ...,
  n,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{sensor}{The name of a sensor. See \link[mpathsenser]{sensors} for a list of available
sensors.}

\item{participant_id}{A character string identifying a single participant. Use get_participants
to retrieve all participants from the database.}

\item{...}{Unquoted names of columns of the \code{sensor} table to average over.}

\item{n}{The number of observations to average over.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}
}
\value{
A tibble with the same columns as the input, modified to be a moving average.
}
\description{
#' @description
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
get_moving_average(db, "Light", "12345", mean_lux, max_lux, n = 5)
}
}
