% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite.R
\name{hermite}
\alias{hermite}
\title{Hermite polynomials}
\usage{
hermite(degree, kind = "he", indeterminate = "x", normalized = FALSE)
}
\arguments{
\item{degree}{degree of polynomial}

\item{kind}{"he" (default, probabilists', see Wikipedia article)
or "h" (physicists)}

\item{indeterminate}{indeterminate}

\item{normalized}{provide normalized coefficients}
}
\value{
a mpoly object or mpolyList object
}
\description{
Hermite polynomials as computed by orthopolynom.
}
\examples{

hermite(0)
hermite(1)
hermite(2)
hermite(3)
hermite(4)
hermite(5)
hermite(6)
hermite(10)

hermite(0:5) 
hermite(0:5, normalized = TRUE)
hermite(0:5, indeterminate = "t")



# visualize the hermite polynomials

library(ggplot2); theme_set(theme_bw())
library(reshape2)

s <- seq(-3, 3, length.out = 201)
N <- 5 # number of hermite polynomials to plot
(hermPolys <- hermite(0:N))

df <- t(sapply(s, as.function(hermPolys)) )
df <- as.data.frame(cbind(s, df))
names(df) <- c("x", paste0("T_", 0:N))
mdf <- melt(df, id = "x")
qplot(x, value, data = mdf, geom = "line", color = variable)



}
\author{
David Kahle calling code from the orthopolynom package
}
\seealso{
\code{\link{hermite.h.polynomials}}, 
  \code{\link{hermite.he.polynomials}}, 
  \url{http://en.wikipedia.org/wiki/Hermite_polynomials}
}

