% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_gaz_search.R
\name{gaz_rest_records_by_lat_long}
\alias{gaz_rest_records_by_lat_long}
\title{Get all gazetteer records where the geometry intersects with the given latitude and longitude}
\usage{
gaz_rest_records_by_lat_long(
  latitude,
  longitude,
  with_geometry = FALSE,
  typeid = NULL
)
}
\arguments{
\item{latitude}{(double) A decimal number which ranges from -90 to 90. Coordinates are assumed to be in WGS84}

\item{longitude}{(double) A decimal number which ranges from -180 to 180. Coordinates are assumed to be in WGS84}

\item{with_geometry}{(logical) Add geometries to the result data frame? Default = FALSE}

\item{typeid}{(numeric) Restrict to one or more placetypeIDs. Retrieve a list of placetypeIDs with \code{\link[=gaz_rest_types]{gaz_rest_types()}}}
}
\value{
A data frame with Gazetteer entries
}
\description{
Get all gazetteer records where the geometry intersects with the given latitude and longitude
}
\examples{
\donttest{
gaz_rest_records_by_lat_long(51.21551, 2.927)
gaz_rest_records_by_lat_long(51.21551, 2.927,
                             with_geometry = TRUE,
                             typeid = c(255, 259))
}
}
\seealso{
\link{gaz_rest}
}
