% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_msaeRB.R
\name{est_msaeRB}
\alias{est_msaeRB}
\title{EBLUPs Ratio Benchmarking based on a Multivariate Fay Herriot (Model 1)}
\usage{
est_msaeRB(
  formula,
  vardir,
  weight,
  samevar = FALSE,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula describe the fitted models}

\item{vardir}{matrix containing sampling variances of direct estimators. The order is: \code{var1, cov12, ..., cov1r, var2, cov23, ..., cov2r, ..., cov(r-1)(r), var(r)}}

\item{weight}{matrix containing proportion of units in small areas. The order is: \code{w1, w2, ..., w(r)}}

\item{samevar}{logical. If \code{TRUE}, the varians is same. Default is \code{FALSE}}

\item{MAXITER}{maximum number of iterations for Fisher-scoring. Default is 100}

\item{PRECISION}{coverage tolerance limit for the Fisher Scoring algorithm. Default value is \code{1e-4}}

\item{data}{dataframe containing the variables named in formula, vardir, and weight}
}
\value{
This function returns a list with following objects:
\item{eblup}{a list containing a value of estimators}
\itemize{
  \item est.eblup : a dataframe containing EBLUP estimators
  \item est.eblupRB : a dataframe containing ratio benchmark estimators
}

\item{fit}{a list contining following objects:}
\itemize{
  \item method : fitting method, named "REML"
  \item convergence : logical value of convergence of Fisher Scoring
  \item iterations : number of iterations of Fisher Scoring algorithm
  \item estcoef : a data frame containing estimated model coefficients (\code{beta, std. error, t value, p-value})
  \item refvar : estimated random effect variance
}
\item{random.effect}{a data frame containing values of random effect estimators}
\item{agregation}{a data frame containing agregation of direct, EBLUP, and ratio benchmark estimation}
}
\description{
This function gives EBLUPs ratio benchmarking based on multivariate Fay-Herriot (Model 1)
}
\examples{
## load dataset
data(datamsaeRB)

# Compute EBLUP and Ratio Benchmark using auxiliary variables X1 and X2 for each dependent variable

## Using parameter 'data'
Fo = list(f1 = Y1 ~ X1 + X2,
          f2 = Y2 ~ X1 + X2,
          f3 = Y3 ~ X1 + X2)
vardir = c("v1", "v12", "v13", "v2", "v23", "v3")
weight = c("w1", "w2", "w3")

est_msae = est_msaeRB(Fo, vardir, weight, data = datamsaeRB)

## Without parameter 'data'
Fo = list(f1 = datamsaeRB$Y1 ~ datamsaeRB$X1 + datamsaeRB$X2,
          f2 = datamsaeRB$Y2 ~ datamsaeRB$X1 + datamsaeRB$X2,
          f3 = datamsaeRB$Y3 ~ datamsaeRB$X1 + datamsaeRB$X2)
vardir = datamsaeRB[, c("v1", "v12", "v13", "v2", "v23", "v3")]
weight = datamsaeRB[, c("w1", "w2", "w3")]

est_msae = est_msaeRB(Fo, vardir, weight)

## Return
est_msae$eblup$est.eblupRB # to see the Ratio Benchmark estimators

}
