% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{set_theme}
\alias{set_theme}
\alias{mschart_theme}
\alias{chart_theme}
\title{set chart theme}
\usage{
set_theme(x, value)

mschart_theme(axis_title = fp_text(bold = TRUE, font.size = 16),
  axis_title_x = axis_title, axis_title_y = axis_title,
  main_title = fp_text(bold = TRUE, font.size = 20),
  legend_text = fp_text(font.size = 14), axis_text = fp_text(),
  axis_text_x = axis_text, axis_text_y = axis_text, title_rot = 0,
  title_x_rot = 0, title_y_rot = 270, axis_ticks = fp_border(color =
  "#99999999"), axis_ticks_x = axis_ticks, axis_ticks_y = axis_ticks,
  grid_major_line = fp_border(color = "#99999999", style = "dashed"),
  grid_major_line_x = grid_major_line, grid_major_line_y = grid_major_line,
  grid_minor_line = fp_border(width = 0),
  grid_minor_line_x = grid_minor_line, grid_minor_line_y = grid_minor_line,
  date_fmt = "yyyy/mm/dd", str_fmt = "General", double_fmt = "#,##0.00",
  integer_fmt = "0", legend_position = "b")

chart_theme(x, axis_title_x, axis_title_y, main_title, legend_text, title_rot,
  title_x_rot, title_y_rot, axis_text_x, axis_text_y, axis_ticks_x,
  axis_ticks_y, grid_major_line_x, grid_major_line_y, grid_minor_line_x,
  grid_minor_line_y, date_fmt, str_fmt, double_fmt, integer_fmt,
  legend_position)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{value}{a \code{mschart_theme} object.}

\item{axis_title, axis_title_x, axis_title_y}{axis title formatting properties (\link[officer]{fp_text})}

\item{main_title}{title formatting properties (\link[officer]{fp_text})}

\item{legend_text}{legend text formatting properties (\link[officer]{fp_text})}

\item{axis_text, axis_text_x, axis_text_y}{axis text formatting properties (\link[officer]{fp_text})}

\item{title_rot, title_x_rot, title_y_rot}{rotation angle}

\item{axis_ticks, axis_ticks_x, axis_ticks_y}{axis ticks formatting properties (\link[officer]{fp_border})}

\item{grid_major_line, grid_major_line_x, grid_major_line_y}{major grid lines formatting properties (\link[officer]{fp_border})}

\item{grid_minor_line, grid_minor_line_x, grid_minor_line_y}{minor grid lines formatting properties (\link[officer]{fp_border})}

\item{date_fmt}{date format}

\item{str_fmt}{string or factor format}

\item{double_fmt}{double format}

\item{integer_fmt}{integer format}

\item{legend_position}{it specifies the position of the legend. It should be
one of 'b', 'tr', 'l', 'r', 't', 'n' (for 'none').}
}
\description{
Modify chart theme with function \code{set_theme}.

Use \code{mschart_theme()} to create a chart theme.

Use \code{chart_theme()} to modify components of the theme of a chart.
}
\examples{
library(officer)
mytheme <- mschart_theme(
  axis_title = fp_text(color = "red", font.size = 24, bold = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = .4, color = "gray") )


my_bc <- ms_barchart(data = browser_data, x = "browser",
                              y = "value", group = "serie")
my_bc <- chart_settings( my_bc, dir="horizontal", grouping="stacked",
                                  gap_width = 150, overlap = 100 )
my_bc <- set_theme(my_bc, mytheme)



my_bc_2 <- ms_barchart(data = browser_data, x = "browser",
                              y = "value", group = "serie")
my_bc_2 <- chart_theme(my_bc_2,
  grid_major_line_y = fp_border(width = .5, color = "cyan") )
}
