% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msp_format.R
\name{WriteMsp}
\alias{WriteMsp}
\title{Write mass spectra in an msp-file (NIST format)}
\usage{
WriteMsp(msp_objs, output_file, fields = NULL)
}
\arguments{
\item{msp_objs}{A list of nested lists. Each nested list is a mass spectrum. Each nested
list must contain at least three elements: (1) \code{name} (a string) -
compound name (or short description); (2) \code{mz} (a numeric/integer
vector) - m/z values of mass spectral peaks; (3) \code{intst} (a
numeric/integer vector) - intensities of mass spectral peaks.}

\item{output_file}{A string. The name of a file.}

\item{fields}{A character vector. Names of elements in an R list (not the original field
names from an msp-file) to be exported. For example, if only CAS number is
needed to be exported, the \code{'cas_no'} (not \code{'cas#'}) should be
passed. If \code{NULL}, all fields are exported. The output file always
contains the 'Name' field, the 'Num Peaks' field, and the mass/intensity
list.}
}
\value{
\code{NULL} is returned.
}
\description{
Write mass spectra in an msp-file (NIST format).
}
\details{
Names of all fields are exported in lower case. It does not cause any
  problem in the case of the MS Search (NIST) software (however correct
  operation with other software products has not been tested). Only in a few
  cases hash symbols and spaces are restored:
  \itemize{
    \item the \code{cas_no} element is exported as the 'cas#' field;
    \item the \code{nist_no} element is exported as the 'nist#' field;
    \item the \code{num_peaks} element is exported as the 'num peaks' field.
  }
}
\examples{

\dontshow{
.old_wd <- setwd(tempdir())
}
# Exporting mass spectra
# Only 'Name', 'SMILES', 'Formula', and 'Num Peaks' fields are exported.
WriteMsp(massbank_alkanes[1:3], "test.msp", fields = c("smiles", "formula"))
\dontshow{
setwd(.old_wd)
}

}
