% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExtraction_mtc.R
\name{add_data_item_to_mtc_device}
\alias{add_data_item_to_mtc_device}
\title{Add a new data item to an existing MTC Device Class}
\usage{
add_data_item_to_mtc_device(mtc_device, data_item_data, data_item_name,
  category = "EVENT")
}
\arguments{
\item{mtc_device}{An existing object of MTCDevice Class}

\item{data_item_data}{Data for the new data item to add}

\item{data_item_name}{Name of the new data item}

\item{category}{Category of the new data item. Can be EVENT or SAMPLE}
}
\description{
Add a new data item to an existing MTC Device Class
}
\examples{
data_item_data = data.frame(timestamp = as.POSIXct(c(0.5, 1, 1.008, 1.011) +
                                        1445579573,  tz = 'CST6CDT', origin = "1970-01-01"),
                            value = c("a", "b", "c", "d"))
data("example_mtc_device")
mtc_device_updated =
   add_data_item_to_mtc_device(example_mtc_device, data_item_data,
    data_item_name = "test", category = "EVENT")
print(mtc_device_updated)
}
