% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{searchBounds}
\alias{searchBounds}
\title{Obtain default bounds for the construction of the search grid.}
\usage{
searchBounds(p0, p1, alpha = 0.05, beta = 0.2, twoSided = TRUE)
}
\arguments{
\item{p0}{the response rate under the null hypothesis}

\item{p1}{the response rate under the alternate hypothesis}

\item{alpha}{the desired (one-sided) type 1 error rate}

\item{beta}{the desired type 2 error rate}

\item{twoSided}{two- or one-sided significance level?}
}
\value{
a list with three elements: "n" - the single stage sample size from
Fleiss et al; "min" - the lower bound, 0.8*n; "max" - the upper bound, 2*n.
\code{floor()} and \code{ceiling()} are applied as appropriate.
}
\description{
The formula used is the continuity corrected Normal approximation from
Fleiss et al (2003).
}
