% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mthacases.R
\name{mthacases}
\alias{mthacases}
\title{Sample size calculations - mtDNA haplogroups}
\usage{
mthacases(p0 = p0, Nh = Nh, OR.cas.ctrl = OR.cas.ctrl, power = power,
  sig.level = sig.level)
}
\arguments{
\item{p0}{the frequency of the haplogroup in the control population, (that is, the controls among exposed). It depends on haplogroup baseline frequency.}

\item{Nh}{number of categories for haplogroups. Usually 10 haplogroups plus one category for rare haplogroups: \code{Nh <- 11}.}

\item{OR.cas.ctrl}{\code{(p1 / (1-p1)) / (p0 / (1-p0))} the OR you want to detect with your data. It can be either a single value, or a sequence: \code{OR.cas.ctrl <- 2}; \code{OR.cas.ctrl <- seq(1.25,3 by=0.5)}.}

\item{power}{the power I want for detecting a given OR in my study (usually 80-90).}

\item{sig.level}{the alpha error accepted. Can take 3 possible values: \code{0.05}, \code{0.01} and \code{0.001} (see [Table 2] of Samuels et al).}
}
\value{
Gives the result in a data frame, easy to print in a plot.
}
\description{
Determine the minimum number of cases (\code{Ncmin}), required to detect: either a change from \code{p0} (haplogroup frequency in controls) to \code{p1} (haplogroup frequency in cases), or a given OR, with a predefined confidence interval, in a study with \code{Nh} haplogroups.
Note: I assume that case-control equations are valid for cohorts with a balanced number of cases and controls.
This function may not be generalizable for all studies involving mtDNA haplogroups.
}
\examples{
mydata <- mthacases(p0=0.445, Nh=11,
                    OR.cas.ctrl=c(2), power=80,
                    sig.level=0.05) # Baudouin study
mydata <- mthacases(p0=0.445, Nh=11,
                    OR.cas.ctrl=c(1.25,1.5,1.75,2,2.25,2.5,2.75,3),
                    power=80, sig.level=0.05)
mydata <- mydata[c(2,6)]
mydata
plot(mydata)

}
\references{
1. DC Samuels, AD Carothers, R Horton, PF Chinnery. The Power to Detect Disease Associations with Mitochondrial DNA Haplogroups. AJHG, 2006. 78(4):713-720. \href{https://www.ncbi.nlm.nih.gov/pmc/PMC1424681}{DOI:10.1086/502682}.

2. Source code: \href{https://github.com/aurora-mareviv/mthapower}{github.com/aurora-mareviv/mthapower}.

3. Shiny app: \href{https://aurora.shinyapps.io/mtDNA_power_calc}{aurora.shinyapps.io/mtDNA_power_calc}.
}
\author{
Author and maintainer: Aurora Baluja. Email: \email{mariauror@gmail.com}
}
