% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VQ_codebookSplit.R
\name{VQ_codebookSplit}
\alias{VQ_codebookSplit}
\title{VQ_codebookSplit}
\usage{
VQ_codebookSplit(dataset, quant.err = 0.5, epsilon = NULL)
}
\arguments{
\item{dataset}{Matrix. A matrix of multivariate data. Each row corresponds
to an observation, and each column corresponds to a variable. Missing values
are not accepted.}

\item{quant.err}{Numeric. The quantization error for the algorithm.}

\item{epsilon}{Numeric. The value to offset the codebooks during the
codebook split. Default is NULL, in which case the value is set to quant.err
parameter.}
}
\value{
\item{clusters}{ List. A list showing each ID assigned to a cluster.
} \item{nodes.clust}{ List. A list corresponding to nodes' details. }
\item{idnodes}{ List. A list of ID and segments similar to
\code{nodes.clust} with additional columns for nodes ID. }
\item{error.quant}{ List. A list of quantization error for all levels and
nodes. } \item{plt.clust}{ List. A list of logical values indicating if the
quantization error was met. } \item{zdata}{ Summary. Output table with
summary. }
}
\description{
Vector Quantization by codebook split method
}
\details{
Performs Vector Quantization by codebook split method. Initially, the entire
dataset is considered to be one cluster where the codebook is the mean of
the cluster. The quantization criteria is checked and the codebook is split
such that the new codebooks are (codebook+epsilon) and (codebook-epsilon).
The observations are reassigned to these new codebooks based on the nearest
neighbour condition and the means recomputed for the new clusters. This is
done iteratively until all the clusters meet the quantization criteria.
}
\examples{


data("iris",package="datasets")
iris <- iris[,1:2]

vqOutput = VQ_codebookSplit(iris, quant.err = 0.5)


}
\seealso{
\code{\link{hvtHmap}}
}
\author{
Meet K. Dave <dave.kirankumar@mu-sigma.com>
}
