% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename.cols}
\alias{rename.cols}
\alias{rename.cols.default}
\alias{rename.cols.qtag}
\title{Replace/rename a column in an object}
\usage{
rename.cols(.data, ..., warn_missing = TRUE, warn_duplicated = TRUE)

\method{rename.cols}{default}(.data, ..., warn_missing = TRUE,
  warn_duplicated = TRUE)

\method{rename.cols}{qtag}(.data, ..., warn_missing = TRUE,
  warn_duplicated = TRUE)
}
\arguments{
\item{.data}{An object that has columns that can be renamed}

\item{...}{Key/value pairs to replace in the form \code{oldval="newval"}}

\item{warn_missing}{Print a message if any old names are not actually present in x}

\item{warn_duplicated}{Print a message if any name appears more than once in x 
after the operation.}
}
\value{
A copy of the modified object
}
\description{
Essentially a thin convenience wrapper around \code{plyr::rename(x, list(...))},
except \link{qtag} objects have their id.vars/tag.vars/measure.vars attributes properly modified.
}
\examples{
data(pocmaj)
rename.cols(pocmaj, Ca="Calcium")
pocmaj2 <- as.qtag(pocmaj, id.vars=c("core", "depth"))
pocmaj2 <- rename.cols(pocmaj2, Ca="Calcium")
attr(pocmaj2, "measure.vars")

}
