% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rn_Gauss.R
\docType{class}
\name{Rn_Gauss-class}
\alias{Rn_Gauss-class}
\alias{Rn_Gauss}
\title{An S4 class to represent the function \eqn{\exp(-\vec{x}\cdot\vec{x})} on \eqn{R^n}}
\description{
Implementation of the function
\deqn{f \colon R^n \to (0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \exp(-\vec{x}\cdot\vec{x}) = \exp(-\sum_{i=1}^n x_i^2),}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{R^n = \times_{i=1}^n R}.
In this case the integral is know to be
\deqn{\int_{R^n} f(\vec{x}) d\vec{x} = \pi^{n/2}.}
}
\details{
The instance needs to be created with one parameter representing \eqn{n}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}
}}

\examples{
n <- as.integer(3)
f <- new("Rn_Gauss",dim=n)
}
