% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-generics.R, R/multiCA.R
\name{multiCA.test}
\alias{multiCA.test}
\alias{multiCA.test.default}
\alias{multiCA.test.formula}
\title{Multinomial Cochran-Armitage trend test}
\usage{
multiCA.test(x, ...)

\method{multiCA.test}{default}(x, scores = 1:ncol(x), outcomes = 1:nrow(x),
  p.adjust.method = c("none", "closed.set", "Holm-Shaffer"), ...)

\method{multiCA.test}{formula}(formula, data, subset, na.action, weights, ...)
}
\arguments{
\item{x}{a two-dimensional matrix of event counts with the outcomes as rows and ordered groups as columns.}

\item{scores}{non-decreaseing numeric vector of the same length as the number of ordered groups. Defaults to linearly increasing values}

\item{outcomes}{integer or character vector defining the set of outcomes (by row index or row name) over which the trend should be tested. Defaults to all outcomes.}

\item{p.adjust.method}{character string defining the correction method for individual outcome p-values. Defaults to "closed.set" when \code{length(outcomes)<=3}, and "Holm-Shaffer" otherwise.}

\item{formula}{a formula of the form \code{outcome ~ group} where \code{outcome} is a factor representing the cateogrical outcome and \code{group} is the grouping variable over which the trend is tested.}

\item{data}{an optional matrix or data frame containing the variables in the formula \code{formula}. By default the variables are taken from \code{environment(formula).}}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}

\item{weights}{an integer-valued variable representing the number of times each \code{outcome} - \code{group} combination was observed.}

\item{\dots}{other arguments}
}
\value{
a list with two components
\item{overall}{an object of class "htest" with the results of the overall test}
\item{individual}{a vector with adjusted p-values for individual outcomes}
}
\description{
The \code{multiCA.test} function performs a multinomial generalization of the 
Cochran-Armitage trend test.
}
\examples{

data(stroke)
## using formula interface
multiCA.test(Type ~ Year, weights=Freq, data=stroke)

## using matrix interface and testing only the first 3 outcomes
strk.mat <- xtabs(Freq ~ Type + Year, data=stroke)
multiCA.test(strk.mat, outcomes=1:3)

}
\author{
Aniko Szabo
}
\references{
Szabo, A. (2016) Test for trend with a multinomial outcome.
}
\keyword{nonparametric}

