% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histNorm.R
\name{histNorm}
\alias{histNorm}
\title{Histogram with normal curve}
\usage{
histNorm(y, breaks = "Sturges", freq = TRUE, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{breaks}{See help file for function \code{hist}.}

\item{freq}{Wheter frequencies (\code{freq = TRUE}) of density (\code{freq = FALSE}) should be represented on \eqn{y}-axis.}

\item{\dots}{Arguments passed to function \code{hist}.}
}
\value{
A list with two elements:
\itemize{
\item \code{x} - breaks, see \code{graphics::hist}.
\item \code{y} - frequencies or relative frequencies, see \code{graphics::hist}.
}
}
\description{
The function draws a histogram with a normal density curve. The parameters (mean and standard deviation) are estimated on the empirical data.
}
\examples{
histNorm(rnorm(1000), freq = TRUE)
histNorm(rnorm(1000), freq = FALSE)
}
\author{
Marjan Cugmas
}
