% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{bridge_output}
\alias{bridge_output}
\title{S3 method for class \code{bridge_output.bmult}}
\usage{
bridge_output(x)
}
\arguments{
\item{x}{object of class \code{bmult} as returned from \code{\link{mult_bf_informed}} or \code{\link{binom_bf_informed}}}
}
\value{
Extracts output related to the bridge sampling routine. The output contains the following elements::

\describe{
\item{\code{$eval}}{
\itemize{
\item \code{q11}: log prior or posterior evaluations for prior or posterior samples
\item \code{q12}: log proposal evaluations for prior or posterior samples
\item \code{q21}: log prior or posterior evaluations for samples from proposal
\item \code{q22}: log proposal evaluations for samples from proposal
}}
\item{\code{$niter}}{number of iterations of the iterative updating scheme}
\item{\code{$logml}}{estimate of log marginal likelihood}
\item{\code{$hyp}}{evaluated inequality constrained hypothesis}
\item{\code{$error_measures}}{
\itemize{
\item \code{re2}: the approximate
relative mean-squared error for the marginal likelihood estimate
\item \code{cv}: the approximate coefficient of variation for the marginal
likelihood estimate (assumes that bridge estimate is unbiased)
\item \code{percentage}: the approximate percentage error of the marginal likelihood estimate
}}
}
}
\description{
Extracts bridge sampling output from object of class \code{bmult}
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Multinomial Case
out_mult  <- mult_bf_informed(x=x, Hr=Hr, a=a, factor_levels=factor_levels,
niter=1e3, seed=2020)
bridge_output <- bridge_output(out_mult)
}
