% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_metadata.R
\name{mc_metadata}
\alias{mc_metadata}
\title{Access the Multi-CAST metadata}
\usage{
mc_metadata(vkey)
}
\arguments{
\item{vkey}{A numeric or character vector of length 1 specifying the
requested version of the annotation values. Must be one of the four-digit
version keys in the first column of \code{\link{mc_index}}, or empty. If
empty or no value is supplied, the most recent version of the annotations
is retrieved automatically.}
}
\value{
A \code{\link[data.table]{data.table}} containing metadata on the
  Multi-CAST collection. The table has the following eight columns:

  \describe{ \item{\code{[, 1] corpus}}{The name of the corpus.}
  \item{\code{[, 2] text}}{The title of the text.} \item{\code{[, 3]
  type}}{The text type, either \code{TN} 'traditional narrative', \code{AN}
  'autobiographical narrative', or \code{SN} 'stimulus-based narrative'.}
  \item{\code{[, 4] recorded}}{The year (YYYY) the text was recorded.}
  \item{\code{[, 5] speaker}}{The identifier for the speaker.} \item{\code{[,
  6] gender}}{The speaker's gender.} \item{\code{[, 7] age}}{The speaker's
  age at the time of recording. Approximate values are prefixed with a
  \code{c}.} \item{\code{[, 8] born}}{The speaker's birth year (YYY).
  Approximate values are prefixed with a \code{c}.} }
}
\description{
\code{mc_metadata} downloads a table with metadata on the texts and speakers
in the Multi-CAST collection. The data is downloaded from the servers of
University of Bamberg and presented as a
\code{\link[data.table]{data.table}}.
}
\examples{
\dontrun{
  # retrieve the most recent version of the Multi-CAST metadata
  mc_metadata()

  # retrieve the lists of referents published in May 2019
  mc_metadata(1905)   # or: mc_metadata("1905")

  # join the metadata to a table with annotation values
  mc <- multicast()
  merge(mc, mc_metadata(), by = c("corpus", "text"))
}

}
\seealso{
\code{\link{multicast}}, \code{\link{mc_index}},
  \code{\link{mc_referents}}, \code{\link{mc_clauses}}
}
