% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submargins.R
\name{submargins}
\alias{submargins}
\title{Average Marginal Substitution Model.}
\usage{
submargins(object, delta, basesub, level = "total", type = "marginal", ...)
}
\arguments{
\item{object}{A fitted \code{\link{brmcoda}} object. Required.}

\item{delta}{A integer, numeric value or vector indicating the amount of substituted change between compositional parts.}

\item{basesub}{A \code{data.frame} or \code{data.table} of the base possible substitution of compositional parts.
This data set can be computed using function \code{\link{basesub}}.
If \code{NULL}, all possible pairwise substitution of compositional parts are used.}

\item{level}{A character string or vector.
Should the estimate be at the \code{between}-person and/or \code{within}-person level? Required.}

\item{type}{A character string or vector.
Should the estimate be \code{conditional} mean or average \code{marginal} mean? Required.}

\item{...}{Additional arguments to be passed to \code{\link{describe_posterior}}.}
}
\value{
A list containing the result of multilevel compositional substitution model.
Each element of the list is the estimation for a compositional part
and include at least six elements.
\itemize{
\item{\code{Mean}}{ Posterior means.}
\item{\code{CI_low}} and \item{\code{CI_high}}{ 95\% credible intervals.}
\item{\code{Delta}}{ Amount substituted across compositional parts.}
\item{\code{From}}{ Compositional part that is substituted from.}
\item{\code{To}}{ Compositional parts that is substituted to.}
\item{\code{Level}}{Level where changes in composition takes place.}
\item{\code{EffectType}}{Either estimated \code{conditional} or average \code{marginal} changes.}
}
}
\description{
Using a fitted model object, estimates the the average marginal difference
when compositional parts are substituted for specific unit(s).
The \code{submargins} output encapsulates
the substitution results for all compositional parts
present in the \code{\link{brmcoda}} object.
}
\examples{
\donttest{
data(mcompd)
data(sbp)
data(psub)
cilr <- compilr(data = mcompd, sbp = sbp, 
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID")

# model with compositional predictor
m <- brmcoda(compilr = cilr, 
             formula = STRESS ~ ilr1 + ilr2 + ilr3 + ilr4 + (1 | ID), 
             chain = 1, iter = 500)
subm <- submargins(object = m, basesub = psub, delta = 5)
}
}
