% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot-coord.R
\name{pivot_coord}
\alias{pivot_coord}
\title{Estimate pivot balance coordinates}
\usage{
pivot_coord(object, summary = TRUE, method = c("rotate", "refit"), ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{summary}{Should summary statistics be returned instead of the raw values? Default is \code{TRUE}.}

\item{method}{A character string.
Should the pivot balance coordinates be estimated by \code{"rotate"} the sequential binary partition
using the same \code{brmcoda} object or \code{"refit"} the \code{brmcoda} object?
Default is \code{"rotate"}.}

\item{...}{currently ignored.}
}
\value{
A list of \code{\link{brmcoda}} for each pivot balance coordinate.
}
\description{
Estimate pivot balance coordinates
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  cilr <- complr(data = mcompd, sbp = sbp,
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID",
                 total = 1440)
  
  # inspects ILRs before passing to brmcoda
  names(cilr$between_logratio)
  names(cilr$within_logratio)
  names(cilr$logratio)
  
  # model with compositional predictor at between and within-person levels
  m <- brmcoda(complr = cilr,
                formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
                                   wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  m_pivot_coord <- pivot_coord(m)
  summary(m_pivot_coord)
  }}
}
