% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-examples.R
\name{example_smk_fe}
\alias{example_smk_fe}
\title{Example smoking FE NMA}
\description{
Calling \code{example("example_smk_fe")} will run a fixed effects
NMA model with the smoking cessation data, using the code in the Examples
section below. The resulting \code{stan_nma} object \code{smk_fit_FE} will then be
available in the global environment.
}
\details{
Smoking FE NMA for use in examples.
}
\examples{
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

\donttest{
# Fitting a fixed effect model
smk_fit_FE <- nma(smk_net, \dontshow{refresh = if (interactive()) 200 else 0,}
                  trt_effects = "fixed",
                  prior_intercept = normal(scale = 100),
                  prior_trt = normal(scale = 100))

smk_fit_FE
}

\dontshow{
if (requireNamespace("pkgdown", quietly = TRUE) && pkgdown::in_pkgdown()) {
  assign("smk_net", smk_net, .GlobalEnv)
  assign("smk_fit_FE", smk_fit_FE, .GlobalEnv)
}
}
}
\keyword{examples}
