% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_nodesplit-class.R
\name{nma_nodesplit-class}
\alias{nma_nodesplit-class}
\alias{nma_nodesplit}
\alias{nma_nodesplit_df}
\alias{nma_nodesplit_df-class}
\title{The nma_nodesplit class}
\description{
The \code{nma_nodesplit} and \code{nma_nodesplit_df} classes contains the results from
running a node-splitting model with the function \code{\link[=nma]{nma()}}.
}
\details{
Objects of class \code{nma_nodesplit} inherit from the \link{stan_nma} class,
and contain the results of fitting a single node-split model. They have one
additional component, \code{nodesplit}, which gives the comparison that was
node-split as a length 2 vector.

Objects of class \code{nma_nodesplit_df} are tibble data frames with one row
for each node-split comparison and columns:
\describe{
\item{\code{trt1}, \code{trt2}}{Treatments forming the comparison}
\item{\code{model}}{A list column containing the results of each model as a
\code{nma_nodesplit} object}
}
Optionally, there will be an additional row for the consistency model if
this was fitted (e.g. by \code{get_nodesplits(., include_consistency = TRUE)})
with \code{trt1} and \code{trt2} both \code{NA}.
}
