% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimates.R
\name{ml_binom}
\alias{ml_binom}
\alias{ml_multinom}
\title{Maximum-likelihood Estimate}
\usage{
ml_binom(k, n, A, b, map, strategy, n.fit = 3, start, progress = FALSE,
  ...)

ml_multinom(k, options, A, b, V, n.fit = 3, start, progress = FALSE,
  ...)
}
\arguments{
\item{k}{vector of observed response frequencies.}

\item{n}{the number of choices per item type.
If \code{k=n=0}, Bayesian inference is relies on the prior distribution only.}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{map}{optional: numeric vector of the same length as \code{k} with integers
mapping the frequencies \code{k} to the free parameters/columns of \code{A}/\code{V},
thereby allowing for equality constraints (e.g., \code{map=c(1,1,2,2)}).
Reversed probabilities \code{1-p} are coded by negative integers.
Guessing probabilities of .50 are encoded by zeros. The default assumes
different parameters for each item type: \code{map=1:ncol(A)}}

\item{strategy}{a list that defines the predictions of a strategy, see\code{\link{strategy_multiattribute}}.}

\item{n.fit}{number of calls to \link[stats]{constrOptim}.}

\item{start}{only relevant if \code{steps} is defined or \code{cmin>0}:
a vector with starting values in the interior of the polytope.
If missing, an approximate maximum-likelihood estimate is used.}

\item{progress}{whether a progress bar should be shown (if \code{cpu=1}).}

\item{...}{further arguments passed to the function
\code{\link[stats]{constrOptim}}. To ensure high accuracy, the number of
maximum iterations should be sufficiently large (e.g., by setting
\code{control = list(maxit = 1e6, reltol=.Machine$double.eps^.6), outer.iterations = 1000}.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}
}
\value{
the list returned by the optimizer \code{\link[stats]{constrOptim}},
  including the input arguments (e.g., \code{k}, \code{options}, \code{A}, \code{V}, etc.).
  \itemize{
  \item If the Ab-representation was used, \code{par} provides the ML estimate for
  the probability vector \eqn{\theta}.
  \item If the V-representation was used, \code{par} provides the estimates for the
  (usually not identifiable) mixture weights \eqn{\alpha} that define the convex
  hull of the vertices in \eqn{V}, while \code{p} provides the ML estimates for
  the probability parameters. Because the weights must sum to one, the
  \eqn{\alpha}-parameter for the last row of the matrix \eqn{V} is dropped.
  If the unconstrained ML estimate is inside the convex hull, the mixture weights
  \eqn{\alpha} are not estimated and replaced by missings (\code{NA}).
  }
}
\description{
Get ML estimate for product-binomial/multinomial model with linear inequality constraints.
}
\details{
First, it is checked whether the unconstrained maximum-likelihood estimator
(e.g., for the binomial: \code{k/n}) is inside the constrained parameter space.
Only if this is not the case, nonlinear optimization with convex linear-inequality
constrained is used to estimate (A) the probability parameters \eqn{\theta}
for the Ab-representation or (B) the mixture weights \eqn{\alpha} for the V-representation.
}
\examples{
# predicted linear order: p1 < p2 < p3 < .50
# (cf. WADDprob in ?strategy_multiattribute)
A <- matrix(c(1, -1,  0,
              0,  1, -1,
              0,  0,  1),
            ncol = 3, byrow = TRUE)
b <- c(0, 0, .50)
ml_binom(k = c(4,1,23), n = 40, A, b)[1:2]
ml_multinom(k = c(4,36,  1,39,  23,17),
            options = c(2,2,2), A, b)[1:2]


# probabilistic strategy:  A,A,A,B  [e1<e2<e3<e4<.50]
strat <- list(pattern = c(-1, -2, -3, 4),
              c = .5, ordered = TRUE, prior = c(1,1))
ml_binom(c(7,3,1, 19), 20, strategy = strat)[1:2]


# vertex representation (one prediction per row)
V <- matrix(c(
  # strict weak orders
  0, 1, 0, 1, 0, 1,  # a < b < c
  1, 0, 0, 1, 0, 1,  # b < a < c
  0, 1, 0, 1, 1, 0,  # a < c < b
  0, 1, 1, 0, 1, 0,  # c < a < b
  1, 0, 1, 0, 1, 0,  # c < b < a
  1, 0, 1, 0, 0, 1,  # b < c < a

  0, 0, 0, 1, 0, 1,  # a ~ b < c
  0, 1, 0, 0, 1, 0,  # a ~ c < b
  1, 0, 1, 0, 0, 0,  # c ~ b < a
  0, 1, 0, 1, 0, 0,  # a < b ~ c
  1, 0, 0, 0, 0, 1,  # b < a ~ c
  0, 0, 1, 0, 1, 0,  # c < a ~ b

  0, 0, 0, 0, 0, 0   # a ~ b ~ c
  ), byrow = TRUE, ncol = 6)
ml_multinom(k = c(4,1,5,  1,9,0,  7,2,1), n.fit = 1,
            options = c(3,3,3), V = V)
}
