% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_binom.R
\name{bf_binom}
\alias{bf_binom}
\alias{bf_multinom}
\title{Bayes Factor for Linear Inequality Constraints}
\usage{
bf_binom(k, n, A, b, V, map, prior = c(1, 1), log = FALSE, ...)

bf_multinom(
  k,
  options,
  A,
  b,
  V,
  prior = rep(1, sum(options)),
  log = FALSE,
  ...
)
}
\arguments{
\item{k}{vector of observed response frequencies.}

\item{n}{the number of choices per item type.
If \code{k=n=0}, Bayesian inference is relies on the prior distribution only.}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}

\item{map}{optional: numeric vector of the same length as \code{k} with integers
mapping the frequencies \code{k} to the free parameters/columns of \code{A}/\code{V},
thereby allowing for equality constraints (e.g., \code{map=c(1,1,2,2)}).
Reversed probabilities \code{1-p} are coded by negative integers.
Guessing probabilities of .50 are encoded by zeros. The default assumes
different parameters for each item type: \code{map=1:ncol(A)}}

\item{prior}{a vector with two positive numbers defining the shape parameters
of the beta prior distributions for each binomial rate parameter.}

\item{log}{whether to return the log-Bayes factor instead of the Bayes factor}

\item{...}{further arguments passed to \code{\link{count_binom}} or
\code{\link{count_multinom}} (e.g., \code{M}, \code{steps}).}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}
}
\value{
a matrix with two columns (Bayes factor and SE of approximation) and three rows:
    \itemize{
      \item \code{`bf_0u`}:  constrained vs. unconstrained (saturated) model
      \item \code{`bf_u0`}:  unconstrained vs. constrained model
      \item \code{`bf_00'`}: constrained vs. complement of inequality-constrained model
             (e.g., pi>.2 becomes pi<=.2; this assumes identical equality constraints for both models)
    }
}
\description{
Computes the Bayes factor for product-binomial/-multinomial models with
linear order-constraints (specified via: \code{A*x <= b} or the convex hull \code{V}).
}
\details{
For more control, use \code{\link{count_binom}} to specifiy how many samples
should be drawn from the prior and posterior, respectively. This is especially
recommended if the same prior distribution (and thus the same prior probability/integral)
is used for computing BFs for multiple data sets that differ only in the
observed frequencies \code{k} and the sample size \code{n}.
In this case, the prior probability/proportion of the parameter space in line
with the inequality constraints can be computed once with high precision
(or even analytically), and only the posterior probability/proportion needs
to be estimated separately for each unique vector \code{k}.
}
\examples{
k <- c(0, 3, 2, 5, 3, 7)
n <- rep(10, 6)

# linear order constraints:
#             p1 <p2 <p3 <p4 <p5 <p6 <.50
A <- matrix(c(1, -1,  0,  0,  0,  0,
              0,  1, -1,  0,  0,  0,
              0,  0,  1, -1,  0,  0,
              0,  0,  0,  1, -1,  0,
              0,  0,  0,  0,  1, -1,
              0,  0,  0,  0,  0,  1),
            ncol = 6, byrow = TRUE)
b <- c(0, 0, 0, 0, 0, .50)

# Bayes factor: unconstrained vs. constrained
bf_binom(k, n, A, b, prior=c(1, 1), M=10000)
bf_binom(k, n, A, b, prior=c(1, 1), M=2000, steps=c(2,4,5))
bf_binom(k, n, A, b, prior=c(1, 1), M=1000, cmin = 200)

}
\references{
Karabatsos, G. (2005). The exchangeable multinomial model as an approach to testing deterministic axioms of choice and measurement. Journal of Mathematical Psychology, 49(1), 51-69. \doi{10.1016/j.jmp.2004.11.001}

Regenwetter, M., Davis-Stober, C. P., Lim, S. H., Guo, Y., Popova, A., Zwilling, C., … Messner, W. (2014). QTest: Quantitative testing of theories of binary choice. Decision, 1(1), 2-34. \doi{10.1037/dec0000007}
}
\seealso{
\code{\link{count_binom}} and \code{\link{count_multinom}} for
    for more control on the number of prior/posterior samples and
    \code{\link{bf_nonlinear}} for nonlinear order constraints.
}
