% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{plot_results}
\alias{plot_results}
\title{Plot data arising from cv.multivar.}
\usage{
plot_results(x, plot_type = "common", facet_ncol = 3, datasets = "all")
}
\arguments{
\item{x}{Object. An object returned by multivar_sim.}

\item{plot_type}{Character. User can specify "common" to plot the common effects matrix, "unique" to plot the unique effects matrix, or "total" to plot the total effects matrix.}

\item{facet_ncol}{Numeric. Number of columns to use in the "unique" or "total" effects plot.}

\item{datasets}{Numeric. A vector containing the index of datasets to plot. Default is "all".}
}
\description{
Plot data arising from cv.multivar.
}
\examples{

sim1  <- multivar_sim(
  k = 2,  # individuals
  d = 3,  # number of variables
  n = 20, # number of timepoints
  prop_fill_com = 0.1, # proportion of paths common
  prop_fill_ind = 0.1, # proportion of paths unique
  lb = 0.1,  # lower bound on coefficient magnitude
  ub = 0.9,  # upper bound on coefficient magnitude
  sigma = diag(1,3) # noise
)

model1 <- constructModel(data = sim1$data, weightest = "ols")
fit1 <- cv.multivar(model1)
plot_results(fit1, plot_type = "common")

}
\keyword{multivar}
\keyword{plot}
\keyword{simulate}
\keyword{var}
