% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{pearson.pvalue}
\alias{pearson.pvalue}
\title{fast p-value approximation}
\usage{
pearson.pvalue(x, vec = 1:ncol(x), type = "multi", ...)
}
\arguments{
\item{x}{matrix, the rows should be iid samples}

\item{vec}{vector, which indicates which columns of \code{x} are treated together as one sample}

\item{type}{one of \code{"multi","total","m.multi.2","m.multi.3"}}

\item{...}{these are passed to \code{\link{cdms}}}
}
\description{
Computes the p-value of a sample using Pearson's approximation of Gaussian quadratic forms with the estimators developed by Berschneider and Böttcher in [4].
}
\details{
This is the method recommended in [4], i.e., using Pearson's quadratic form estimate with the unbiased finite sample estimators for the mean and variance of normalized multivariance together with the unbiased estimator for the limit skewness.
}
\references{
For the theoretic background see the reference [4] given on the main help page of this package: \link{multivariance-package}.
}
