% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_projector.R
\name{partial_project.cross_projector}
\alias{partial_project.cross_projector}
\title{Partially project data for a cross_projector}
\usage{
\method{partial_project}{cross_projector}(
  x,
  new_data,
  colind,
  least_squares = TRUE,
  lambda = 1e-06,
  source = c("X", "Y"),
  ...
)
}
\arguments{
\item{x}{A \code{cross_projector} object.}

\item{new_data}{A numeric matrix (n x length(colind)) or vector, representing
the observations corresponding to the columns specified by \code{colind}.}

\item{colind}{A numeric vector of column indices in the original data space
(either X or Y domain, specified by \code{source}) that correspond to \code{new_data}'s columns.}

\item{least_squares}{Logical; if TRUE (default), use ridge-regularized least squares for projection.}

\item{lambda}{Numeric; ridge penalty (default 1e-6). Ignored if \code{least_squares=FALSE}.}

\item{source}{Character, either "X" or "Y", indicating which domain \code{new_data} and \code{colind} belong to.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A numeric matrix (n x d) of factor scores in the latent subspace.
}
\description{
Projects new data from either the X or Y domain onto the latent subspace,
considering only a specified subset of original features (\code{colind}).
}
